#SHADER_DEFINE DisplaceVertex
    FUNCTION_INPUT =
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoord"},
	}

	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCoord" },
	}

#SHADER_CODE
    vec2 out_TexCoord = in_TexCoord;
    gl_Position = in_Position;
#END_CODE
#END_DEFINE

#SHADER_DEFINE DisplaceFragment
	FUNCTION_INPUT =
	{
        { FRAME_SIZE,		       HIGH,	    FLOAT,		    "in_FrameSize"},
        { CUR_FRAME_ID,            HIGH,        FLOAT,          "in_CurFrameID"},
        { DIRECTION,	           MEDIUM,	    FLOAT,		    "in_Direction"},
        { INTERVAL,	               MEDIUM,	    FLOAT,		    "in_Interval"},
        { ROW_FRAME_NUM_PER_TEX,   HIGH,	    FLOAT,		    "in_RowFrameNumPerTex"},
        { COL_FRAME_NUM_PER_TEX,   HIGH,	    FLOAT,		    "in_ColFrameNumPerTex"},
        { TOTAL_PERIOD,            MEDIUM,      FLOAT,		    "in_TotalPeriod"},
        { HISTORICAL_FRAME1,	   NONE,	    TEXTURE2D,	    "in_Tex1" },
        { HISTORICAL_FRAME2,	   NONE,	    TEXTURE2D,	    "in_Tex2" },
        { HISTORICAL_FRAME3,	   NONE,	    TEXTURE2D,	    "in_Tex3" },
        { HISTORICAL_FRAME4,	   NONE,	    TEXTURE2D,	    "in_Tex4" },
        { ATTRIBUTE_COORDNATE0,	   MEDIUM,	    VEC2,		    "in_TexCoord"},
	}

#SHADER_CODE
    highp int iFrameSize = int(in_FrameSize);
    highp int iCurFrameID = int(in_CurFrameID);
    highp int iRowFrameNumPerTex = int(in_RowFrameNumPerTex);
    highp int iColFrameNumPerTex = int(in_ColFrameNumPerTex);

    int minus_frames = 0;
    if (in_Direction < 0.)     //x - direction
    {
        if (in_Interval > 0.)
        {
            minus_frames = int(in_TexCoord.x / in_Interval);
        }
        else
        {
            minus_frames = int((1.0 - in_TexCoord.x) / abs(in_Interval));
        }
    }
    else
    {
        if (in_Interval < 0.)
        {
            minus_frames = int(in_TexCoord.y / in_Interval);
        }
        else
        {
            minus_frames = int((1.0 - in_TexCoord.y) / abs(in_Interval));
        }
    }
    
    float frame_delay = in_TotalPeriod / (1.0 / abs(in_Interval));
    minus_frames = int((frame_delay / 1000.0) * 30.0) * minus_frames;
    
    int frame_id = int(mod(iCurFrameID - minus_frames, iFrameSize));

    int FRAME_NUM_PER_TEX = iRowFrameNumPerTex * iColFrameNumPerTex;      
    int tex_id = frame_id / FRAME_NUM_PER_TEX;
    int local_frame_id = int(mod(frame_id, FRAME_NUM_PER_TEX));
    
    float x_scale = 1.0 / in_RowFrameNumPerTex;
    float y_scale = 1.0 / in_ColFrameNumPerTex;

    int divide = local_frame_id / iRowFrameNumPerTex;
    float tex_x_start = x_scale * mod(local_frame_id, iRowFrameNumPerTex);
    float tex_y_start = y_scale * float(iColFrameNumPerTex - 1 - divide);

    vec2 tex_pos = vec2(tex_x_start, tex_y_start) + vec2(x_scale, y_scale) * in_TexCoord;

    vec3 rgb = vec3(0.0, 0.0, 0.0);
    if (tex_id == 0)
      rgb = texture2D(in_Tex1, tex_pos).rgb;
    else if (tex_id == 1)
      rgb = texture2D(in_Tex2, tex_pos).rgb;
    else if (tex_id == 2)
      rgb = texture2D(in_Tex3, tex_pos).rgb;
    else if (tex_id == 3)
      rgb = texture2D(in_Tex4, tex_pos).rgb;

    gl_FragColor = vec4(rgb,1.0);
#END_CODE
#END_DEFINE