#SHADER_DEFINE DenoiseVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
    
#END_CODE
#END_DEFINE



#SHADER_DEFINE DenoiseVertexNew

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			MEDIUM,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
    { PIXEL_OFFSETS,            MEDIUM, VEC2,   "in_Offsets"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ SQUARE_COORDNATE,		  MEDIUM,		VEC2_ARRAY,		"out_SquareCoord", "9" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    
    mediump vec2 out_SquareCoord[9];
    
    // first row
    out_SquareCoord[0] = in_TexCoordinate.xy - in_Offsets.xy;     // upper left corner
    out_SquareCoord[1] = vec2(in_TexCoordinate.x , in_TexCoordinate.y - in_Offsets.y);
    out_SquareCoord[2] = vec2(in_TexCoordinate.x + in_Offsets.x , in_TexCoordinate.y - in_Offsets.y);     // upper right corner
    
    // second row
    out_SquareCoord[3] = vec2(in_TexCoordinate.x - in_Offsets.x , in_TexCoordinate.y);
    out_SquareCoord[4] = in_TexCoordinate.xy;
    out_SquareCoord[5] = vec2(in_TexCoordinate.x + in_Offsets.x , in_TexCoordinate.y);
    
    // thrid row
    out_SquareCoord[6] = vec2(in_TexCoordinate.x - in_Offsets.x , in_TexCoordinate.y + in_Offsets.y);     // lower left corner
    out_SquareCoord[7] = vec2(in_TexCoordinate.x , in_TexCoordinate.y + in_Offsets.y); 
    out_SquareCoord[8] = in_TexCoordinate.xy + in_Offsets.xy;     // lower right corner
    
#END_CODE
#END_DEFINE


#SHADER_DEFINE DenoiseFragment

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },

    { SQUARE_COORDNATE,	MEDIUM,	VEC2_ARRAY,		"square_coordinates","9"}
    
	}

#SHADER_CODE

    
    mediump vec3 curr = texture2D(uniCurrentTexture,square_coordinates[4]).xyz;

    mediump vec3 pre_1 = texture2D(uniCurrentTexture, square_coordinates[0]).xyz;
    mediump vec3 post_1 = texture2D(uniCurrentTexture, square_coordinates[8]).xyz;
   
    mediump vec3 pre_2 = texture2D(uniCurrentTexture, square_coordinates[1]).xyz;
    mediump vec3 post_2 = texture2D(uniCurrentTexture, square_coordinates[7]).xyz;
    
    mediump vec3 pre_3 = texture2D(uniCurrentTexture, square_coordinates[2]).xyz;
    mediump vec3 post_3 = texture2D(uniCurrentTexture, square_coordinates[6]).xyz;
    
    mediump vec3 pre_4 = texture2D(uniCurrentTexture, square_coordinates[3]).xyz;
    mediump vec3 post_4 = texture2D(uniCurrentTexture, square_coordinates[5]).xyz;
    
    mediump vec3 diff_1 = post_1 - pre_1;
    mediump vec3 sum_1  = post_1 + pre_1;
    mediump vec3 diff_2 = post_2 - pre_2;
    mediump vec3 sum_2  = post_2 + pre_2;
    mediump vec3 diff_3 = post_3 - pre_3;
    mediump vec3 sum_3  = post_3 + pre_3;
    mediump vec3 diff_4 = post_4 - pre_4;
    mediump vec3 sum_4  = post_4 + pre_4;
    
    mediump vec3 var_12 = (curr * 2.0 - sum_1) / ((diff_1 * diff_1 * 3000.0) + 8.0) + (curr * 2.0 - sum_2) / ((diff_2 * diff_2 * 3000.0) + 8.0);
    mediump vec3 var_34 = (curr * 2.0 - sum_3) / ((diff_3 * diff_3 * 3000.0) + 8.0) + (curr * 2.0 - sum_2) / ((diff_4 * diff_4 * 3000.0) + 8.0);
    
    curr -= (var_12+var_34);
    
    mediump vec4 tmpColor;
    tmpColor.w = 1.0;
    tmpColor.x = curr.x;
    tmpColor.y = curr.y;
    tmpColor.z = curr.z;
    
    gl_FragColor = tmpColor;


#END_CODE
#END_DEFINE




#SHADER_DEFINE DenoiseFragmentThreeFrame

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { TEXTURE_PRE_FRAME,		NONE,	TEXTURE2D,		"uniPreTexture" },
    { TEXTURE_PRE_PRE_FRAME,		NONE,	TEXTURE2D,		"uniPrePreTexture" },
    { SQUARE_COORDNATE,	MEDIUM,	VEC2_ARRAY,		"square_coordinates","9"},
    
	}

#SHADER_CODE



  
    
    mediump vec3 curr = texture2D(uniCurrentTexture,square_coordinates[4]).xyz;
    
    mediump vec3 diff_pre2 = texture2D(uniPrePreTexture, square_coordinates[4]).xyz-curr;
    mediump vec3 var_pre = -0.5 * diff_pre2 / ( diff_pre2 * diff_pre2 * 1600.0 + 2.0 );
    
    mediump vec3 diff_pre =  texture2D(uniPreTexture, square_coordinates[4]).xyz-curr;
    var_pre = 0.25 * (var_pre - diff_pre / ( diff_pre * diff_pre * 1600.0 + 2.0 ))*1000.0;
    
    
    mediump vec3 pre_1 = texture2D(uniCurrentTexture, square_coordinates[0]).xyz;
    mediump vec3 post_1 = texture2D(uniCurrentTexture, square_coordinates[8]).xyz;
   
    mediump vec3 pre_2 = texture2D(uniCurrentTexture, square_coordinates[1]).xyz;
    mediump vec3 post_2 = texture2D(uniCurrentTexture, square_coordinates[7]).xyz;
    
    mediump vec3 pre_3 = texture2D(uniCurrentTexture, square_coordinates[2]).xyz;
    mediump vec3 post_3 = texture2D(uniCurrentTexture, square_coordinates[6]).xyz;
    
    mediump vec3 pre_4 = texture2D(uniCurrentTexture, square_coordinates[3]).xyz;
    mediump vec3 post_4 = texture2D(uniCurrentTexture, square_coordinates[5]).xyz;
    
    mediump vec3 diff_1 = post_1 - pre_1;
    mediump vec3 sum_1  = post_1 + pre_1;
    mediump vec3 diff_2 = post_2 - pre_2;
    mediump vec3 sum_2  = post_2 + pre_2;
    mediump vec3 diff_3 = post_3 - pre_3;
    mediump vec3 sum_3  = post_3 + pre_3;
    mediump vec4 diff_4 = post_4 - pre_4;
    mediump vec3 sum_4  = post_4 + pre_4;
    
    mediump vec3 var_12 = (curr * 2.0 - sum_1) / ((diff_1 * diff_1 * 3000.0) + 8.0) + (curr * 2.0 - sum_2) / ((diff_2 * diff_2 * 3000.0) + 8.0);
    mediump vec3 var_34 = (curr * 2.0 - sum_3) / ((diff_3 * diff_3 * 3000.0) + 8.0) + (curr * 2.0 - sum2) / ((diff_4 * diff_4 * 3000.0) + 8.0);
    
    curr -= (var_12+var_34);
    curr -= var_pre;
    
    mediump vec4 tmpColor;
    tmpColor.w = 1.0;
    tmpColor.x = curr;
    tmpColor.y = curr;
    tmpColor.z = curr;
    
    
    
  gl_FragColor = tmpColor;
  
  
  
  
 
  

#END_CODE
#END_DEFINE






