uniform vec2 topRight;
uniform vec2 bottomLeft;
uniform float smoothFactor;

// Taken from https://stackoverflow.com/questions/12751080/glsl-point-inside-box-test/37426532
float getMask(vec2 uv) {
    // Smooth factor is reduced by 1/4
    float s = smoothFactor / 4. + 0.001;
    vec2 maxDist = max(bottomLeft - uv, uv - topRight);
    // When smoothing, the distance is calculated to an inner rect
    maxDist = maxDist + s / 2.;
    // Internal coordinates doesn't count for distance
    maxDist = max(maxDist, vec2(0.0, 0.0));

    float dist = distance(maxDist, vec2(0.0, 0.0));
    float mask = -dist / s + 1.;
    return clamp(mask, 0., 1.);
}
