local basetype = require "venuscore.rtti.types.basetype"


local ComboType = basetype:extend("ComboType");


function ComboType:new(comboSource, get, set)
  ComboType.super.new(self, get, set);
  local comboSourceType = type(comboSource);
  if comboSourceType == "function" then
    self.funcGetComboData = comboSource;
  elseif comboSourceType == "table" then
    self.funcGetComboData = function(obj)
      return comboSource;
    end;
  end
end


function ComboType:GetComboData(obj)
  return self.funcGetComboData(obj)
end


return ComboType;