local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local SpinePropertyChangeCommand = CommandBase:extend("SpinePropertyChangeCommand");

function SpinePropertyChangeCommand:new(uuid, propertyKey, value, func)
  SpinePropertyChangeCommand.super.new(self);
  self._uuid = uuid;
  self._propertyKey = propertyKey;
  self._value = value;
  self._func = func;
  self._preValue = nil;
end

function SpinePropertyChangeCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local spineCom = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if spineCom then
      self._preValue = spineCom[self._propertyKey];
      self._func(spineCom, self._propertyKey, self._value);
    end
  end
  self:EndCmd();
end

function SpinePropertyChangeCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local spineCom = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if spineCom then
      self._func(spineCom, self._propertyKey, self._preValue);
    end
  end
  self:EndCmd();
end

return SpinePropertyChangeCommand;
