


local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local SegDebugCommand = CommandBase:extend("SegDebugCommand");

function SegDebugCommand:new(uuid,value)
  SegDebugCommand.super.new(self);
  self._uuid = uuid;
  self._value = value;
end


function SegDebugCommand:DoIt()
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      self._preValue = self._value == true and false or true;
      com:OnDebug(self._value);
    end
  end
end

function SegDebugCommand:Undo()
  if self._uuid then
    local com = self:GetContent(self._uuid);
    if com and self._prevalue then
      com:OnDebug(self._preValue);
    end
  end
end

return SegDebugCommand;
