

local venuscore = require "venuscore"
local CommandBase = require "venuscore.command.command"
local SetScriptValue = CommandBase:extend("SetScriptValue");

function SetScriptValue:new(comUUID,scriptPath,key,value)
  SetScriptValue.super.new(self);
  self._key = key;
  self._comUUID = comUUID;
  self._scriptPath = scriptPath;
  self._curData = value;
end


function SetScriptValue:DoIt()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for key,ins in pairs(scriptIns) do
        if key == self._scriptPath then
          self._preData = ins:GetScriptValue(self._key);
          ins:SetScriptValue(self._key,self._curData);
        end
      end
    end
  end
  self:EndCmd();
end

function SetScriptValue:Undo()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for key,ins in pairs(scriptIns) do
        if key == self._scriptPath then
          if self._preData then
            ins:SetScriptValue(self._key,self._preData);
          end
        end
      end
    end
  end
  self:EndCmd();
end


return SetScriptValue;
