

local venuscore = require "venuscore"
local CommandBase = require "venuscore.command.command"
local SetScriptRef = CommandBase:extend("SetScriptRef");

function SetScriptRef:new(comUUID,scriptPath,key,refUUID)
  SetScriptRef.super.new(self);
  self._key = key;
  self._comUUID = comUUID;
  self._scriptPath = scriptPath;
  self._curUUID = refUUID;
end


function SetScriptRef:DoIt()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    local tar = self:GetContent(self._curUUID);
    if com then
      local scriptIns = com.Instances;
      for key,ins in pairs(scriptIns) do
        if key == self._scriptPath then
          local preobj = ins:GetScriptValue(self._key);
          if preobj == nil then
            self._preUUID = nil;
          else
            self._preUUID = preobj:GetContentPath();
          end
          ins:SetScriptValue(self._key,tar);
        end
      end
    end
  end
  self:EndCmd();
end

function SetScriptRef:Undo()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for key,ins in pairs(scriptIns) do
        if key == self._scriptPath then
          if self._preUUID then
            local tar = self:GetContent(self._preUUID);
            ins:SetScriptValue(self._key,tar);
          else
            ins:SetScriptValue(self._key,nil);
          end
        end
      end
    end
  end
  self:EndCmd();
end


return SetScriptRef;
