

local venuscore = require "venuscore"
local CommandBase = require "venuscore.command.command"
local SetScriptValueByKeys = CommandBase:extend("SetScriptValueByKeys");

function SetScriptValueByKeys:new(comUUID, scriptPath, keys, value)
  SetScriptValueByKeys.super.new(self);
  self._keys = { unpack(keys) };
  self._comUUID = comUUID;
  self._scriptPath = scriptPath;
  self._curData = value;
end

function SetScriptValueByKeys:DoIt()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for path, inst in pairs(scriptIns) do
        if path == self._scriptPath then
          local target, targetKey = self._SearchScriptInst(inst, self._keys)
          if target ~= nil then
            self._preData = target:GetScriptValue(targetKey);
            target:SetScriptValue(targetKey, self._curData);
          end
        end
      end
    end
  end
  self:EndCmd();
end

function SetScriptValueByKeys:Undo()
  self:BeginCmd();
  if self._comUUID and self._preData ~= nil then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for path, inst in pairs(scriptIns) do
        if path == self._scriptPath then
          local target, targetKey = self._SearchScriptInst(inst, self._keys)
          if target ~= nil then
            target:SetScriptValue(targetKey, self._preData);
          end
        end
      end
    end
  end
  self:EndCmd();
end


return SetScriptValueByKeys;
