

local venuscore = require "venuscore"
local CommandBase = require "venuscore.command.command"
local SetScriptRefByKeys = CommandBase:extend("SetScriptRefByKeys");

function SetScriptRefByKeys:new(comUUID, scriptPath, keys, refUUID)
  SetScriptRefByKeys.super.new(self);
  self._keys = { unpack(keys) };
  self._comUUID = comUUID;
  self._scriptPath = scriptPath;
  self._curUUID = refUUID;
end


function SetScriptRefByKeys:DoIt()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    local tar = self:GetContent(self._curUUID);
    if com then
      local scriptIns = com.Instances;
      for path, inst in pairs(scriptIns) do
        if path == self._scriptPath then
          local target, targetKey = self._SearchScriptInst(inst, self._keys)
          local preobj = target:GetScriptValue(targetKey);
          if preobj == nil then
            self._preUUID = nil;
          else
            self._preUUID = preobj:GetContentPath();
          end
          target:SetScriptValue(targetKey, tar);
        end
      end
    end
  end
  self:EndCmd();
end

function SetScriptRefByKeys:Undo()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for path, inst in pairs(scriptIns) do
        if path == self._scriptPath then
          local target, targetKey = self._SearchScriptInst(inst, self._keys)
          if self._preUUID then
            local tar = self:GetContent(self._preUUID);
            target:SetScriptValue(targetKey, tar);
          else
            target:SetScriptValue(targetKey, nil);
          end
        end
      end
    end
  end
  self:EndCmd();
end


return SetScriptRefByKeys;
