

local venuscore = require "venuscore"
local CommandBase = require "venuscore.command.command"
local SetBehaviorRef = CommandBase:extend("SetBehaviorRef");

function SetBehaviorRef:new(comUUID,scriptPath,key,refHostUUID,refScriptPath)
  SetBehaviorRef.super.new(self);
  self._key = key;
  self._comUUID = comUUID;
  self._scriptPath = scriptPath;
  self._refHostID = refHostUUID;
  self._refScriptPath = refScriptPath;
  self._preRefHostID = nil;
  self._preRefScriptPath = nil;
end


function SetBehaviorRef:DoIt()
  self:BeginCmd();
  if self._comUUID and self._refHostID then
    local com = self:GetContent(self._comUUID);
    local refCom = self:GetContent(self._refHostID);
    local refScript = nil;
    local refInstList = refCom.Instances;
    for key, value in pairs(refInstList) do
      if self._refScriptPath == key then
        refScript = value;
      end
    end
    
    if com and refScript then
      local scriptIns = com.Instances;
      for key,ins in pairs(scriptIns) do
        if key == self._scriptPath then
          local preobj = ins:GetScriptValue(self._key);
          if preobj == nil then
            self._preRefHostID = nil;
            self._preRefScriptPath = nil;
          else
            self._preRefHostID = preobj._hostID;
            self._preRefScriptPath = preobj._path;
          end
          ins:SetScriptValue(self._key,refScript);
        end
      end
    end
  end
  self:EndCmd();
end

function SetBehaviorRef:Undo()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for key,ins in pairs(scriptIns) do
        if key == self._scriptPath then
          if self._preRefHostID and self._preRefScriptPath then
            local refCom = self:GetContent(self._preRefHostID);
            local refScript = nil;
            local refInstList = refCom.Instances;
            for key, value in pairs(refInstList) do
              if self._preRefScriptPath == key then
                refScript = value;
              end
            end
            ins:SetScriptValue(self._key,refScript);
          else
            ins:SetScriptValue(self._key,nil);
          end
        end
      end
    end
  end
  self:EndCmd();
end


return SetBehaviorRef;
