

local venuscore = require "venuscore"
local CommandBase = require "venuscore.command.command"
local SetBehaviorRefByKeys = CommandBase:extend("SetBehaviorRefByKeys");

function SetBehaviorRefByKeys:new(comUUID, scriptPath, keys, refHostUUID, refScriptPath)
  SetBehaviorRefByKeys.super.new(self);
  self._keys = { unpack(keys) };
  self._comUUID = comUUID;
  self._scriptPath = scriptPath;
  self._refHostID = refHostUUID;
  self._refScriptPath = refScriptPath;
  self._preRefHostID = nil;
  self._preRefScriptPath = nil;
end


function SetBehaviorRefByKeys:DoIt()
  self:BeginCmd();
  if self._comUUID and self._refHostID then
    local com = self:GetContent(self._comUUID);
    local refCom = self:GetContent(self._refHostID);
    local refScript = nil;
    local refInstList = refCom.Instances;
    for path, inst in pairs(refInstList) do
      if self._refScriptPath == path then
        refScript = inst;
      end
    end
    if com and refScript then
      local scriptIns = com.Instances;
      for path, inst in pairs(scriptIns) do
        if path == self._scriptPath then
          local target, targetKey = self._SearchScriptInst(inst, self._keys)
          local preobj = target:GetScriptValue(targetKey);
          if preobj == nil then
            self._preRefHostID = nil;
            self._preRefScriptPath = nil;
          else
            self._preRefHostID = preobj._hostID;
            self._preRefScriptPath = preobj._path;
          end
          target:SetScriptValue(targetKey, refScript);
        end
      end
    end
  end
  self:EndCmd();
end

function SetBehaviorRefByKeys:Undo()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for path, inst in pairs(scriptIns) do
        if path == self._scriptPath then
          local target, targetKey = self._SearchScriptInst(inst, self._keys)
          if self._preRefHostID and self._preRefScriptPath then
            local refCom = self:GetContent(self._preRefHostID);
            local refScript = nil;
            local refInstList = refCom.Instances;
            for refPath, refInst in pairs(refInstList) do
              if self._preRefScriptPath == refPath then
                refScript = refInst;
              end
            end
            target:SetScriptValue(targetKey, refScript);
          else
            target:SetScriptValue(targetKey, nil);
          end
        end
      end
    end
  end
  self:EndCmd();
end


return SetBehaviorRefByKeys;
