

local venuscore = require "venuscore"
local CommandBase = require "venuscore.command.command"
local DelScriptCommand = CommandBase:extend("DelScriptCommand");

function DelScriptCommand:new(comUUID,scriptPath)
  DelScriptCommand.super.new(self);
  self._comUUID = comUUID;
  self._scriptPath = scriptPath;
end


function DelScriptCommand:DoIt()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for key,ins in pairs(scriptIns) do
        if key == self._scriptPath then
          ins:Disable();
          ins:Destroy();
          com:RemoveInstance(key);
        end
      end
    end
  end
  self:EndCmd();
end

function DelScriptCommand:Undo()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local instance = venuscore.LoadBehavior(self._scriptPath);
      if instance then
        com:InsertInstance(instance,self._scriptPath);
        instance:SetUniqueKey(com:GetContentPath(),self._scriptPath);
        instance:Awake();
      end
    end
  end
  self:EndCmd();
end


return DelScriptCommand;
