

local venuscore = require "venuscore"
local CommandBase = require "venuscore.command.command"
local DelScriptArrayItemByKeys = CommandBase:extend("DelScriptArrayItemByKeys");

function DelScriptArrayItemByKeys:new(comUUID, scriptPath, keys, index)
  DelScriptArrayItemByKeys.super.new(self);
  self._keys = { unpack(keys) };
  self._comUUID = comUUID;
  self._scriptPath = scriptPath;
  self.index = index
end

function DelScriptArrayItemByKeys:DoIt()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for path, inst in pairs(scriptIns) do
        if path == self._scriptPath then
          local target, targetKey = self._SearchScriptInst(inst, self._keys)
          if target ~= nil then
            self.delItem = target[targetKey][self.index]
            table.remove(target[targetKey], self.index)
          end
        end
      end
    end
  end
  self:EndCmd();
end

function DelScriptArrayItemByKeys:Undo()
  self:BeginCmd();
  if self._comUUID and self._preData ~= nil then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for path, inst in pairs(scriptIns) do
        if path == self._scriptPath then
          local target, targetKey = self._SearchScriptInst(inst, self._keys)
          if target ~= nil then
            table.insert(target[targetKey], self.index, self.delItem)
            -- insert before current 'self.index' of array
          end
        end
      end
    end
  end
  self:EndCmd();
end


return DelScriptArrayItemByKeys;
