

local venuscore = require "venuscore"
local CommandBase = require "venuscore.command.command"
local AddScriptCommand = CommandBase:extend("AddScriptCommand");

function AddScriptCommand:new(comUUID,scriptPath)
  AddScriptCommand.super.new(self);
  self._comUUID = comUUID;
  self._scriptPath = scriptPath;
end


function AddScriptCommand:DoIt()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local instance = venuscore.LoadBehavior(self._scriptPath);
      if instance then
        com:InsertInstance(instance,self._scriptPath);
        instance:SetUniqueKey(com:GetContentPath(),self._scriptPath);
        instance:Awake();
      end      
    end
  end
  self:EndCmd();
end

function AddScriptCommand:Undo()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      com:RemoveInstance(self._scriptPath);
    end
  end
  self:EndCmd();
end


return AddScriptCommand;
