

local venuscore = require "venuscore"
local CommandBase = require "venuscore.command.command"
local AddScriptArrayItemByKeys = CommandBase:extend("AddScriptArrayItemByKeys");

function AddScriptArrayItemByKeys:new(comUUID, scriptPath, keys)
  AddScriptArrayItemByKeys.super.new(self);
  self._keys = { unpack(keys) };
  self._comUUID = comUUID;
  self._scriptPath = scriptPath;
end

function AddScriptArrayItemByKeys:DoIt()
  self:BeginCmd();
  if self._comUUID then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for path, inst in pairs(scriptIns) do
        if path == self._scriptPath then
          local target, targetKey = self._SearchScriptInst(inst, self._keys)
          if target ~= nil then
            local typeinfo = target:GetTypeInfomation(targetKey);
            local defaultItem = typeinfo:GetDefaultItem(target);
            self.appendItem = defaultItem
            --if target[targetKey] ~= nil then
            --  target[targetKey] = {}
            --end
            table.insert(target[targetKey] , defaultItem)
          end
        end
      end
    end
  end
  self:EndCmd();
end

function AddScriptArrayItemByKeys:Undo()
  self:BeginCmd();
  if self._comUUID and self._preData ~= nil then
    local com = self:GetContent(self._comUUID);
    if com then
      local scriptIns = com.Instances;
      for path, inst in pairs(scriptIns) do
        if path == self._scriptPath then
          local target, targetKey = self._SearchScriptInst(inst, self._keys)
          if target ~= nil then
             for index, value in ipairs(target[targetKey]) do
                if value == self.appendItem then
                  table.remove(target[targetKey], index)
                  break;
                end
             end
          end
        end
      end
    end
  end
  self:EndCmd();
end


return AddScriptArrayItemByKeys;
