
local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local Stringsplit = require "stringsplit"
local ScenePropertyChangeCommand = CommandBase:extend("ScenePropertyChangeCommand");

function ScenePropertyChangeCommand:new(keyName,value,index)
  ScenePropertyChangeCommand.super.new(self);
  self._keyname = keyName;
  self._value = value;
end


function ScenePropertyChangeCommand:DoIt()
  local scene = self:GetScene();
    if scene then
      local physic = scene:GetPhysicWorld();
      self._preValue = physic[self._keyname]; --之前值
      physic[self._keyname] = self._value
    end
end
function ScenePropertyChangeCommand:Undo()
  local scene = self:GetScene();
    if scene then
      local physic = scene;GetPhysicWorld();
      physic[self._keyname] = self._preValue;
    end
end

return ScenePropertyChangeCommand;
