


local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local apollocore = require "apollocore"

local DestroyNodeCmd = CommandBase:extend("DestroyNodeCmd");

function DestroyNodeCmd:new(nodeUUID)
  DestroyNodeCmd.super.new(self);
  --生成一个唯一UUID,命令同步到其他Scene时候，也用相同UUID
  self._nodeUUID = nodeUUID;
end


function DestroyNodeCmd:DoIt()
  local scene = self:GetScene();
  if scene then
    local node = scene:GetNode(self._nodeUUID);
    if node then
      scene:DeleteNode(self._nodeUUID);
    end
  end
end

function DestroyNodeCmd:Undo()
  --DO NOTHING!!删除了不可恢复
end

return DestroyNodeCmd;
