
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local apollocore = require "apollocore"

local CreateTextNodeCmd = CommandBase:extend("CreateTextNodeCmd");

function CreateTextNodeCmd:new(fontPath)
  CreateTextNodeCmd.super.new(self);
  --生成一个唯一UUID,命令同步到其他Scene时候，也用相同UUID
  self._nodeUUID = ContentManager:GenerateUUID();
  self.fontPath = fontPath;
end

function CreateTextNodeCmd:DoIt()
  local textNode = nil;
  local scene = self:GetScene();
  if scene then
    textNode = scene:CreateTextNode(self.fontPath);
    textNode:SetStaticID(self._nodeUUID);
    local trans = textNode:GetComponent(apollocore.Node.CT_TRANSFORM);
    if self._transUUID == nil then
      self._transUUID = trans:GetStaticID();
    else
      trans:SetStaticID(self._transUUID);
    end
    local render = textNode:GetComponent(apollocore.Node.CT_RENDER);
    if self._renderUUID == nil then
      self._renderUUID = render:GetStaticID();
    else
      render:SetStaticID(self._renderUUID);
    end
  end
  return textNode;
end

function CreateTextNodeCmd:Undo()
  local scene = self:GetScene();
  if scene then
    local node = scene:GetContent(self._nodeUUID);
    scene:DestroyNode(node);
  end
end

return CreateTextNodeCmd;
