
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local apollocore = require "apollocore"

local CreateSpineNodeCmd = CommandBase:extend("CreateSpineNodeCmd");

function CreateSpineNodeCmd:new(skeleton, atlaspath, material)
  CreateSpineNodeCmd.super.new(self);
  --生成一个唯一UUID,命令同步到其他Scene时候，也用相同UUID
  self._nodeUUID = ContentManager:GenerateUUID();
  self._nodeName = "SpineNode"
  self._atlaspath = atlaspath;
  self._skeleton = skeleton;
  self._material = material;
end

function CreateSpineNodeCmd:DoIt()
  local spineNode = nil;
  local scene = self:GetScene();
  if scene then
    spineNode = scene:CreateSpineNode();
    spineNode:CreateResource(self._atlaspath, self._skeleton, self._material);
    spineNode:PushAnimation(spineNode:GetDefaultAnimation(), true, 0);
     spineNode:SetStaticID(self._nodeUUID);
    spineNode:SetName(self._nodeName);
    local trans = spineNode:GetComponent(apollocore.Node.CT_TRANSFORM);
    if self._transUUID == nil then
      self._transUUID = trans:GetStaticID();
    else
      trans:SetStaticID(self._transUUID);
    end
    local spineCom = spineNode:GetComponent(apollocore.Node.CT_SPINE_COMPONENT);
    if self._spineComUUID == nil then
      self._spineComUUID = spineCom:GetStaticID();
    else
      spineCom:SetStaticID(self._spineComUUID);
    end
    local render = spineNode:GetComponent(apollocore.Node.CT_RENDER);
    if self._renderUUID == nil then
      self._renderUUID = render:GetStaticID();
    else
      render:SetStaticID(self._renderUUID);
    end
  end
  return spineNode.node;
end

function CreateSpineNodeCmd:Undo()
  local scene = self:GetScene();
  if scene then
    local node = scene:GetContent(self._nodeUUID);
    scene:DestroyNode(node);
  end
end

return CreateSpineNodeCmd;
