
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local apollocore = require "apollocore"

local CreateParticleNodeCmd = CommandBase:extend("CreateParticleNodeCmd");

function CreateParticleNodeCmd:new(name)
  CreateParticleNodeCmd.super.new(self);
  --生成一个唯一UUID,命令同步到其他Scene时候，也用相同UUID
  self._nodeUUID = ContentManager:GenerateUUID();
  self._nodeName = name or "ParticleNode"
end

function CreateParticleNodeCmd:DoIt()
  local particleNode = nil;
  local scene = self:GetScene();
  if scene then
    particleNode = scene:CreateParticleNode();
    particleNode:CreateResource();
    particleNode:SetStaticID(self._nodeUUID);
    particleNode:SetName(self._nodeName);
    local trans = particleNode:GetComponent(apollocore.Node.CT_TRANSFORM);
    if self._transUUID == nil then
      self._transUUID = trans:GetStaticID();
    else
      trans:SetStaticID(self._transUUID);
    end
    
    local billboardRender = particleNode:GetBillboardRender();
    if self._billboardRenderUUID == nil then
      self._billboardRenderUUID = billboardRender:GetStaticID();
    else
      billboardRender:SetStaticID(self._billboardRenderUUID);
    end
    
    local meshNode = particleNode:GetMeshTemplateNode();
    if self._meshNodeUUID == nil then
      self._meshNodeUUID = meshNode:GetStaticID();
    else
      meshNode:SetStaticID(self._meshNodeUUID);
    end
    
    
    local meshRender = particleNode:GetMeshRender();
    if self._meshRenderUUID == nil then
      self._meshRenderUUID = meshRender:GetStaticID();
    else
      meshRender:SetStaticID(self._meshRenderUUID);
    end
    
      
  end
  return particleNode.node;
end

function CreateParticleNodeCmd:Undo()
  local scene = self:GetScene();
  if scene then
    local node = scene:GetContent(self._nodeUUID);
    scene:DestroyNode(node);
  end
end

return CreateParticleNodeCmd;
