

local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local apollocore = require "apollocore"

local CreateGenericNodeCmd = CommandBase:extend("CreateGenericNodeCmd");

function CreateGenericNodeCmd:new(name)
  CreateGenericNodeCmd.super.new(self);
  --生成一个唯一UUID,命令同步到其他Scene时候，也用相同UUID
  self._nodeUUID = ContentManager:GenerateUUID();
  self._nodeName = name or "Node"
end


function CreateGenericNodeCmd:DoIt()
  local node = nil;
  local scene = self:GetScene();
  if scene then
    node = scene:CreateGenericNode();
    --GenericNode里边会默认创建TransComponent
    --我们要保证TansformComponent的ID和Peview场景要一致
    local trans = node:GetComponent(apollocore.Node.CT_TRANSFORM);
    if self._transUUID == nil then
      self._transUUID = trans:GetStaticID();
    else
      trans:SetStaticID(self._transUUID);
    end
    
    node:SetStaticID(self._nodeUUID);
    node:SetName(self._nodeName);
  end
  return node;
end

function CreateGenericNodeCmd:Undo()
  local scene = self:GetScene();
  if scene then
    local node = scene:GetContent(self._nodeUUID);
    scene:DestroyNode(node);
  end
end

return CreateGenericNodeCmd;
