


local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local apollocore = require "apollocore"

local CreateBasicobjectCmd = CommandBase:extend("CreateBasicobjectCmd");




function CreateBasicobjectCmd:new(name)
  CreateBasicobjectCmd.super.new(self);
  --生成一个唯一UUID,命令同步到其他Scene时候，也用相同UUID
  self._nodeUUID = ContentManager:GenerateUUID();
  self._nodeName = name or "Node"
end


function CreateBasicobjectCmd:DoIt()
  local node = nil;
  local scene = self:GetScene();
  if scene then
    node = scene:CreateGenericNode();
    --GenericNode里边会默认创建TransComponent
    --我们要保证TansformComponent的ID和Peview场景要一致
    local trans = node:GetComponent(apollocore.Node.CT_TRANSFORM);
    if self._transUUID == nil then
      self._transUUID = trans:GetContentPath();
    else
      trans:SetStaticID(self._transUUID);
    end
    
    node:SetNativeStaticID(self._nodeUUID);
    node:SetName(self._nodeName);
  end
  return node;
end

function CreateBasicobjectCmd:Undo()
  local scene = self:GetScene();
  if scene then
    local node = scene:GetContent(self._nodeUUID);
    scene:DestroyNode(node);
  end
end

return CreateBasicobjectCmd;
