


local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local CreateComponentCommand = CommandBase:extend("RMCreateComponentCommand");

function CreateComponentCommand:new(uuid,typeName,host_uuid,doFunc)
  CreateComponentCommand.super.new(self);
  self._uuid = uuid;
  self._typeName = typeName;
  self._hostID = host_uuid;  --这里有问题，这里保存个host会导致host删除不掉,所以这里也保存uuid
  self._doFunc = doFunc;
end


function CreateComponentCommand:DoIt()
  self:BeginCmd();
  local component = nil;
  if self._uuid then
    local object = ContentManager:GetObjectByUUID(self._uuid);
    local hostObject = ContentManager:GetObjectByUUID(self._hostID);
    if object and hostObject then
      component = self._doFunc(object,self._typeName,hostObject);
      self._ComponentType = component:GetComponentType();
    end
  end
  self:EndCmd();
  return component;
end

function CreateComponentCommand:Undo()
  if self._uuid then
    local object = ContentManager:GetObjectByUUID(self._uuid);
    local hostObject = ContentManager:GetObjectByUUID(self._hostID);
    if object and hostObject then
      hostObject:DeleteComponent(self._ComponentType);
    end
  end
end

return CreateComponentCommand;
