local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local SetCollisionShapeCommand = CommandBase:extend("SetCollisionShapeCommand");

function SetCollisionShapeCommand:new(uuid, shape)
  SetCollisionShapeCommand.super.new(self);
  self._uuid = uuid;
  self._shape = shape;
end

function SetCollisionShapeCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
	    self._preValue = self._shape
      com:SetCollisionShape(self._shape)
    end
  end
  self:EndCmd();
end

function SetCollisionShapeCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      com:SetCollisionShape(self._preValue)
    end
  end
  self:EndCmd();
end

return SetCollisionShapeCommand;