local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local CleanMotionCommand = CommandBase:extend("CleanMotionCommand");

function CleanMotionCommand:new(uuid)
  CleanMotionCommand.super.new(self);
  self._uuid = uuid;
end

function CleanMotionCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      com:CleanMotion();
    end
  end
  self:EndCmd();
end

function CleanMotionCommand:Undo()

end

return CleanMotionCommand;