local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local SetRenderPropertyCommand = CommandBase:extend("SetRenderPropertyCommand");

function SetRenderPropertyCommand:new(uuid, propertyid)
  SetRenderPropertyCommand.super.new(self);
  self._uuid = uuid;
  self._propertyId = propertyid;
end

function SetRenderPropertyCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      com:SetRenderProperty(self._propertyId)
    end
  end
  self:EndCmd();
end

function SetRenderPropertyCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      com:EraseRenderProperty(self._propertyId)
    end
  end
  self:EndCmd();
end

return SetRenderPropertyCommand;