local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local mat = require "window.editor.widget.inspector.panels.assets.mat"

local SetParameterCommand = CommandBase:extend("SetParameterCommand");

function SetParameterCommand:new(uuid, materialidx, att, value, prevalue, matname)
  SetParameterCommand.super.new(self);
  self._uuid = uuid;
  self._materialidx = materialidx;
  self._att = att;
  self._value = value;
  self._preValue = prevalue;
  self._matName = matname;
  self._toCacheIDs = true
end

function SetParameterCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      local materialList = com.MaterialEntities;
      self._material = materialList[self._materialidx];
      com:SetParameter(self._materialidx, self._att, self._value);
      
      if self._value:isType(apolloengine.TextureEntity:RTTI()) then
        self._texUni = self._value;
      end

      if self._value:isType(apolloengine.TextureEntity:RTTI()) or 
        self._value:isType(apolloengine.RenderTargetEntity:RTTI()) then
        local deplist = {}
        local params = self._material:GetParameterList()
        for key, param in pairs(params) do
          if param:isType(apolloengine.TextureEntity:RTTI()) or 
            param:isType(apolloengine.RenderTargetEntity:RTTI()) then
            local mds = param.SourceMetadata
            for i = 1, #mds do
              if mds[i].GetDependencePathList then
                local texMetadatas = mds[i]:GetDependencePathList()
                for j = 1, #texMetadatas do   -- 依次添加纹理的依赖资源
                  deplist[#deplist+1] = texMetadatas[j];
                end
              end
              if mds[i].Path then
                deplist[#deplist+1] = mds[i].Path -- 添加纹理的元数据
              end
            end
          end
        end
        local matmds = self._material.SourceMetadata
        matmds[1]:SetDependencePathList(deplist)
      end
      
      if self._matName ~= "" and self._toCacheIDs then
        self._toCacheIDs = false
        mat.SaveOneMat(self._material);
      end
    end
  end
  self:EndCmd();
end

function SetParameterCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      com:SetParameter(self._materialidx, self._att, self._preValue);
      
      if self._value:isType(apolloengine.TextureEntity:RTTI()) then
        self._texUni = self._preValue;
      end

      if self._preValue:isType(apolloengine.TextureEntity:RTTI()) or 
        self._preValue:isType(apolloengine.RenderTargetEntity:RTTI()) then
        local deplist = {}
        local mds = self._preValue.SourceMetadata
        for i = 1, #mds do
          if mds[i].Path then
            deplist[#deplist+1] = mds[i].Path
          end
        end
        local matmds = self._material.SourceMetadata
        matmds[1]:SetDependencePathList(deplist)
      end
      
      if self._matName ~= "" and not self._toCacheIDs then
        mat.SaveOneMat(self._material);
        self._toCacheIDs = true
      end
    end
  end
  self:EndCmd();
end

return SetParameterCommand;