local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local EraseRenderPropertyCommand = CommandBase:extend("EraseRenderPropertyCommand");

function EraseRenderPropertyCommand:new(uuid, propertyid)
  EraseRenderPropertyCommand.super.new(self);
  self._uuid = uuid;
  self._propertyId = propertyid;
end

function EraseRenderPropertyCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      com:EraseRenderProperty(self._propertyId)
    end
  end
  self:EndCmd();
end

function EraseRenderPropertyCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      com:SetRenderProperty(self._propertyId)
    end
  end
  self:EndCmd();
end

return EraseRenderPropertyCommand;