local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local DeleteMaterialCommand = CommandBase:extend("DeleteMaterialCommand");

function DeleteMaterialCommand:new(uuid, size)
  DeleteMaterialCommand.super.new(self);
  self._uuid = uuid;
  self._size = size;
end

function DeleteMaterialCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com  then
      local materialList = com.MaterialEntities;
      if #materialList < 1 then
        return
      end
      self._prevMatPath = materialList[self._size+1]:GetMatPath();
      self._prevShaderPath = materialList[self._size+1]:GetShaderPath();
      com:ResizeMaterials(self._size);
    end
  end
  self:EndCmd();
end

function DeleteMaterialCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      local materialEntity = apolloengine.MaterialEntity();
      if self._prevMatPath ~= "" then
        materialEntity:PushMetadata(apolloengine.MaterialMetadata(self._prevMatPath));
      else
        materialEntity:PushMetadata(apolloengine.PathMetadata(self._prevShaderPath));
      end
      materialEntity:CreateResource();
      com:ChangeMaterial(materialEntity, self._size + 1);
    end
  end
  self:EndCmd();
end

return DeleteMaterialCommand;
