local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local mat = require "window.editor.widget.inspector.panels.assets.mat"

local ChangeOneMatCommand = CommandBase:extend("ChangeOneMatCommand");

function ChangeOneMatCommand:new(uuid, entityIndex, changematerial)
  ChangeOneMatCommand.super.new(self);
  self._uuid = uuid;
  self._entityIndex = entityIndex;
  self._changeMaterialPath = changematerial;
  self._preMaterialPath = nil;
  self._toCacheIDs = true
end

function ChangeOneMatCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      local materials = com.MaterialEntities;
      if materials then
        local matrialEntity = materials[self._entityIndex];
        if matrialEntity then
          self._preMaterialPath = matrialEntity:GetShaderPath();
          matrialEntity:ChangeShaderPath(self._changeMaterialPath)
          if self._toCacheIDs then
            mat.SaveOneMat(matrialEntity, self._changeMaterialPath)
            self._toCacheIDs = false
          end
        end
      end
    end
  end
  self:EndCmd();
end

function ChangeOneMatCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid);
    if com then
      local materials = com.MaterialEntities;
      if materials then
        local matrialEntity = materials[self._entityIndex];
        if matrialEntity then
          if self._preMaterialPath then
            matrialEntity:ChangeShaderPath(self._preMaterialPath);
            if not self._toCacheIDs then
              mat.SaveOneMat(matrialEntity, self._preMaterialPath)
              self._toCacheIDs = true
            end
          end
        end
      end
    end
  end
  self:EndCmd();
end

return ChangeOneMatCommand;