local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local ChangeMeshCommand = CommandBase:extend("ChangeMeshCommand");

function ChangeMeshCommand:new(uuid, metadata)
  ChangeMeshCommand.super.new(self);
  self._uuid = uuid;
  self._metadata = metadata;
end

function ChangeMeshCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      local meshPath = (com.RenderObjectEntity):GetMeshName();
      if filelfs:getExtension(meshPath) == "mesh" then
        self._preMetadata = apolloengine.RenderObjectMeshFileMetadate(apolloengine.VertexBufferEntity.MU_STATIC, meshPath);
      elseif filelfs:getExtension(meshPath) == "dynamicmesh" then
        self._preMetadata = apolloengine.RenderObjectMeshFileMetadate(apolloengine.VertexBufferEntity.MU_DYNAMIC, meshPath);
      end
      com:ChangeRenderObjectEntity(self._metadata);
    end
  end
  self:EndCmd();
end

function ChangeMeshCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      com:ChangeRenderObjectEntity(self._preMetadata);
    end
  end
  self:EndCmd();
end

return ChangeMeshCommand;