local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local apollocore = require "apollocore"
local defined = require "window.editor.system.defined"

local ChangeMaterialCommand = CommandBase:extend("ChangeMaterialCommand");

function ChangeMaterialCommand:new(uuid, matPath, preMatPath, size)
  ChangeMaterialCommand.super.new(self);
  self._uuid = uuid;
  self._matPath = matPath;
  self._prevMatPath = preMatPath;
  self._size = size;
end

function ChangeMaterialCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      local materialEntity = apolloengine.MaterialEntity();
      local extension = filelfs:getExtension(self._matPath);
      if extension == defined.FileTypeList.Mat then
        local meta = apolloengine.MaterialMetadata(self._matPath);
        local sceneid = self:GetSceneID();
        meta:SetSceneID(sceneid);
        materialEntity:PushMetadata(meta);
      else
        materialEntity:PushMetadata(apolloengine.PathMetadata(self._matPath));
      end
      materialEntity:CreateResource();
      com:ChangeMaterial(materialEntity, self._size);
    end
  end
  self:EndCmd();
end

function ChangeMaterialCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      local materialEntity = apolloengine.MaterialEntity();
      local extension = filelfs:getExtension(self._prevMatPath);
      if extension == defined.FileTypeList.Mat then
        materialEntity:PushMetadata(apolloengine.MaterialMetadata(self._prevMatPath));
      else
        materialEntity:PushMetadata(apolloengine.PathMetadata(self._prevMatPath));
      end
      materialEntity:CreateResource();
      com:ChangeMaterial(materialEntity, self._size);
    end
  end
  self:EndCmd();
end

return ChangeMaterialCommand;
