local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AddMaterialCommand = CommandBase:extend("AddMaterialCommand");
local apollocore = require "apollocore"

function AddMaterialCommand:new(uuid, matpath, size)
  AddMaterialCommand.super.new(self);
  self._uuid = uuid;
  self._matPath = matpath;
  self._size = size;
end

function AddMaterialCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com  then
      local meta = apolloengine.MaterialMetadata(self._matPath);
      local sceneid = self:GetSceneID();
      meta:SetSceneID(sceneid);
      local materialEntity = apolloengine.MaterialEntity();
      materialEntity:PushMetadata(meta);
      materialEntity:CreateResource();
      com:ChangeMaterial(materialEntity, self._size);
    end
  end
  self:EndCmd();
end

function AddMaterialCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      com:ResizeMaterials(self._size-1);
    end
  end
  self:EndCmd();
end

return AddMaterialCommand;
