local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local Stringsplit = require "stringsplit"
local RefChangeCommand = CommandBase:extend("RefChangeCommand");

function RefChangeCommand:new(uuid,keyName, uuidother, index)
  RefChangeCommand.super.new(self);
  self._uuid = uuid;
  self._keynames = Stringsplit(keyName,".")
  self._uuidother = uuidother;
  self._indexes= index;
end

function RefChangeCommand:GetObj(com,keys)
  local ret = com;
  for i=1,#keys-1 do
    if type(ret[keys[i]]) == "table" and self._indexes~=nil  then
      ret = ret[keys[i]][self._indexes[i]];
    else
      ret = ret[keys[i]];
    end
  end
  return ret;
end

function RefChangeCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    local other = self:GetContent(self._uuidother)
    if com then
        local obj = self:GetObj(com,self._keynames);
        local lastkey = self._keynames[#self._keynames];

        if type(obj[lastkey]) == "table" then
          obj[lastkey][self._indexes[#self._indexes]] = other;
          self._preValue = obj[lastkey][self._indexes[#self._indexes]];
        else
          self._preValue = obj[lastkey]; --之前值
          obj[lastkey] = other
        end
        
    end
  end
  self:EndCmd();
end

function RefChangeCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid);
    if com then
      local obj = self:GetObj(com,self._keynames);
      local lastkey = self._keynames[#self._keynames];

      if type(obj[lastkey]) == "table" then
        obj[lastkey][self._indexes[#self._indexes]] = self._preValue;
      else
        obj[lastkey] = self._preValue
      end

    end
  end
  self:EndCmd();
end

return RefChangeCommand;