


local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local PropertyIndexChangeCommand = CommandBase:extend("PropertyIndexChangeCommand");

function PropertyIndexChangeCommand:new(uuid,keyName,value,index,itemName)
  PropertyIndexChangeCommand.super.new(self);
  self._uuid = uuid;
  self._keyName = keyName;
  self._value = value;
  self._index = index;
  self._itemName = itemName;
end


function PropertyIndexChangeCommand:DoIt()
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      self._preValue = com[self._keyName][self._index][self._itemName]; --之前值
      com[self._keyName][self._index][self._itemName] = self._value
    end
  end
end

function PropertyIndexChangeCommand:Undo()
  if self._uuid then
    local com = self:GetContent(self._uuid);
    if com then
      com[self._keyName][self._index][self._itemName] = self._preValue;
    end
  end
end

return PropertyIndexChangeCommand;
