


local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local PropertyChangeCommand = CommandBase:extend("PropertyChangeCommand");

function PropertyChangeCommand:new(uuid,keyName,value,beforefunc,afterfunc)
  PropertyChangeCommand.super.new(self);
  self._uuid = uuid;
  self._keyName = keyName;
  self._value = value;
  self._beforefunc = beforefunc;
  self._afterfunc = afterfunc;
end


function PropertyChangeCommand:DoIt()
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      if self._beforefunc ~= nil then
        self._beforefunc(com);
      end
      self._preValue = com[self._keyName]; --之前值
      com[self._keyName] = self._value
      if self._afterfunc ~= nil then
        self._afterfunc(com);
      end
    end
  end
end

function PropertyChangeCommand:Undo()
  if self._uuid then
    local com = self:GetContent(self._uuid);
    if com then
      if self._beforefunc ~= nil then
        self._beforefunc(com);
      end
      com[self._keyName] = self._preValue;
      if self._afterfunc ~= nil then
        self._afterfunc(com);
      end
    end
  end
end

return PropertyChangeCommand;
