local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local ParticleSpeedRandChangeCmd = CommandBase:extend("ParticleSpeedRandChangeCmd");

function ParticleSpeedRandChangeCmd:new(uuid,modifierIndex,propertyKey,setValue)
  ParticleSpeedRandChangeCmd.super.new(self);
  self._uuid = uuid;
  self._modifierIndex = modifierIndex;
  self._propertyKey = propertyKey;
  self._preValue = nil;
  self._setValue = setValue;
end

function ParticleSpeedRandChangeCmd:DoIt()
  self:BeginCmd();
  if self._uuid then
    local Emmiter = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if Emmiter then
      local Types, Affectors = Emmiter:GetAffectors();
      local speedAffector = Affectors[self._modifierIndex];
      if speedAffector then
        self._preValue = speedAffector.RandVolume[self._propertyKey];
        speedAffector.RandVolume[self._propertyKey] = self._setValue;
      end
    end
  end
  self:EndCmd();
end

function ParticleSpeedRandChangeCmd:Undo()
  self:BeginCmd();
  if self._uuid then
     local Emmiter = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if Emmiter then
      local Types, Affectors = Emmiter:GetAffectors();
      local speedAffector = Affectors[self._modifierIndex];
      if speedAffector then
        speedAffector.RandVolume[self._propertyKey] = self._preValue;
      end
    end
  end
  self:EndCmd();
end

return ParticleSpeedRandChangeCmd;
