local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local ParticleRendererProChangeCmd = CommandBase:extend("ParticleRendererProChangeCmd");

function ParticleRendererProChangeCmd:new(uuid,propertyKey,setValue)
  ParticleRendererProChangeCmd.super.new(self);
  self._uuid = uuid;
  self._propertyKey = propertyKey;
  self._preValue = nil;
  self._setValue = setValue;
end

function ParticleRendererProChangeCmd:DoIt()
  self:BeginCmd();
  if self._uuid then
    local Emmiter = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if Emmiter then
      local particleRenderer = Emmiter.ParticleRenderer;
      if particleRenderer then
        self._preValue = particleRenderer[self._propertyKey];
        particleRenderer[self._propertyKey] = self._setValue;
      end
    end
  end
  self:EndCmd();
end

function ParticleRendererProChangeCmd:Undo()
  self:BeginCmd();
  if self._uuid then
     local Emmiter = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if Emmiter then
       local particleRenderer = Emmiter.ParticleRenderer;
      if particleRenderer then
        particleRenderer[self._propertyKey] = self._preValue;
      end
    end
  end
  self:EndCmd();
end

return ParticleRendererProChangeCmd;
