local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local ParticleModifierSetCurveCmd = CommandBase:extend("ParticleModifierSetCurveCmd");

function ParticleModifierSetCurveCmd:new(uuid,modifierIndex,curIndex,newcurve)
  ParticleModifierSetCurveCmd.super.new(self);
  self._uuid = uuid;
  self._modifierIndex = modifierIndex;
  self._curIndex = curIndex;
  self._preCurve = nil;
  self._newcurve = newcurve;
end

function ParticleModifierSetCurveCmd:DoIt()
  self:BeginCmd();
  if self._uuid then
    local Emmiter = self:GetContent(self._uuid); 
    if Emmiter then
      local modifier = Emmiter:GetModifies()[self._modifierIndex];
      if modifier then
        self._preCurve = modifier:GetCurve(self._curIndex);
        modifier:SetCurve(self._curIndex, self._newcurve);
      end
    end
  end
  self:EndCmd();
end

function ParticleModifierSetCurveCmd:Undo()
  self:BeginCmd();
  if self._uuid then
    local Emmiter = self:GetContent(self._uuid); 
    if Emmiter then
      local modifier = Emmiter:GetModifies()[self._modifierIndex];
      if modifier then
        modifier:SetCurve(self._curIndex, self._preCurve);
      end
    end
  end
  self:EndCmd();
end

return ParticleModifierSetCurveCmd;
