local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local imguifunction = require "imguifunction"
local ParticleModifierSetColGraCmd = CommandBase:extend("ParticleModifierSetColGraCmd");

function ParticleModifierSetColGraCmd:new(uuid,modifierIndex,preGradient,newGradient)
  ParticleModifierSetColGraCmd.super.new(self);
  self._uuid = uuid;
  self._modifierIndex = modifierIndex;
  self._preGradient = preGradient;
  self._newGradient = newGradient;
end

function ParticleModifierSetColGraCmd:DoIt()
  self:BeginCmd();
  if self._uuid then
    local Emmiter = self:GetContent(self._uuid); 
    if Emmiter then
      local modifier = Emmiter:GetModifies()[self._modifierIndex];
      if modifier then
        modifier:SetColorGradientOne(self._newGradient);
      end
    end
  end
  self:EndCmd();
end

function ParticleModifierSetColGraCmd:Undo()
  self:BeginCmd();
  if self._uuid then
    local Emmiter = self:GetContent(self._uuid); 
    if Emmiter then
      local modifier = Emmiter:GetModifies()[self._modifierIndex];
      if modifier then
        modifier:SetColorGradientOne(self._preGradient);
        imguifunction.ImGui:SetGradient(self._preGradient);
      end
    end
  end
  self:EndCmd();
end

return ParticleModifierSetColGraCmd;
