local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local ParticleModifierProchangeCmd = CommandBase:extend("ParticleModifierProchangeCmd");

function ParticleModifierProchangeCmd:new(uuid,modifierIndex,propertyKey,setValue)
  ParticleModifierProchangeCmd.super.new(self);
  self._uuid = uuid;
  self._modifierIndex = modifierIndex;
  self._propertyKey = propertyKey;
  self._preValue = nil;
  self._setValue = setValue;
end

function ParticleModifierProchangeCmd:DoIt()
  self:BeginCmd();
  if self._uuid then
    local Emmiter = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if Emmiter then
      local modifier = Emmiter:GetModifies()[self._modifierIndex];
      if modifier then
        self._preValue = modifier[self._propertyKey];
        modifier[self._propertyKey] = self._setValue;
      end
    end
  end
  self:EndCmd();
end

function ParticleModifierProchangeCmd:Undo()
  self:BeginCmd();
  if self._uuid then
   local Emmiter = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if Emmiter then
      local modifier = Emmiter:GetModifies()[self._modifierIndex];
      if modifier then
        modifier[self._propertyKey] = self._preValue;
      end
    end
  end
  self:EndCmd();
end

return ParticleModifierProchangeCmd;
