local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local ParticleCurveShowCmd = CommandBase:extend("ParticleCurveShowCmd");

function ParticleCurveShowCmd:new(showFunc,hash,index,iscurve,iscur,curves)
  ParticleCurveShowCmd.super.new(self);
  self._showFunc = showFunc;
  self._hash = hash
  self._index = index;
  self._iscurve = iscurve; 
  self._preiscur = iscurve; 
  self._iscur = iscur; 
  self._curves = curves;
end


function ParticleCurveShowCmd:DoIt()
  self:BeginCmd();
  if self._showFunc then
   self._showFunc(self._hash,self._index,self._iscurve,self._iscur,self._curves);
  end
  self:EndCmd();
end

function ParticleCurveShowCmd:Undo()
  self:BeginCmd();
  self._showFunc(self._hash,self._index,self._iscurve,self._preiscur,self._curves);
  self:EndCmd();
end

return ParticleCurveShowCmd;
