local apollocore = require "apollocore"
local CommandBase = require "venuscore.command.command"
local mathfunction = require "mathfunction"
local SelectShapeAffectorCommand = CommandBase:extend("SelectShapeAffectorCommand");

function SelectShapeAffectorCommand:new(uuid, affectorType)
  SelectShapeAffectorCommand.super.new(self);
  self._uuid = uuid;
  self._affectorType = affectorType;
end

function SelectShapeAffectorCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local emitter = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if emitter then
      self._preAffectorType = self._affectorType;
      local shapeAffectors = self:GetShapeAffectorList(emitter);
      local currentAffector = self:GetAffector(shapeAffectors, self._affectorType);
      for k, v in pairs(shapeAffectors) do
        v:Disable();
      end
      currentAffector:Enable();
      self:ChangeBindBox(emitter, currentAffector);
    end
  end
  self:EndCmd();
end

function SelectShapeAffectorCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local emitter = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if emitter then
      local shapeAffectors = self:GetShapeAffectorList(emitter);
      local currentAffector = self:GetAffector(shapeAffectors, self._preAffectorType);
      for k, v in pairs(shapeAffectors) do
        v:Disable();
      end
      currentAffector:Enable();
      self:ChangeBindBox(emitter, currentAffector);
    end
  end
  self:EndCmd();
end

function SelectShapeAffectorCommand:GetShapeAffectorList(emitter)
  local shapeAffectors = {};
  local _, affectorList = emitter:GetAffectors();
  for i = 1, #affectorList do
    if affectorList[i]:GetTypeName() == "PositionSphereAffector" then
      table.insert(shapeAffectors, affectorList[i]);
    elseif affectorList[i]:GetTypeName() == "PositionBoxAffector" then
      table.insert(shapeAffectors, affectorList[i]);
    elseif affectorList[i]:GetTypeName() == "PositionConeAffector" then
      table.insert(shapeAffectors, affectorList[i]);
    elseif affectorList[i]:GetTypeName() == "PositionHemisphereAffector" then
      table.insert(shapeAffectors, affectorList[i]);
    end
  end
  return shapeAffectors;
end

function SelectShapeAffectorCommand:GetAffector(affectorList, affectorType)
  for i = 1, #affectorList do
    if affectorList[i]:GetTypeName() == affectorType then
      return affectorList[i];
    end
  end
  return nil;
end

function SelectShapeAffectorCommand:ChangeBindBox(emitter, selectedAffector)
  local bindboxV = mathfunction.Aabbox3d(
          mathfunction.vector3(-0.1, 0, -0.1),
          mathfunction.vector3(0.1, 0.1, 0.1));
  if selectedAffector:isType(apollocore.PositionSphereAffector:RTTI()) then
    bindboxV = mathfunction.Aabbox3d(
            mathfunction.vector3(selectedAffector.Center:x() - selectedAffector.Radius,
                    selectedAffector.Center:y() - selectedAffector.Radius,
                    selectedAffector.Center:z() - selectedAffector.Radius),
            mathfunction.vector3(selectedAffector.Center:x() + selectedAffector.Radius,
                    selectedAffector.Center:y() + selectedAffector.Radius,
                    selectedAffector.Center:z() + selectedAffector.Radius));
  elseif selectedAffector:isType(apollocore.PositionBoxAffector:RTTI()) then
    bindboxV = mathfunction.Aabbox3d(
            mathfunction.vector3(selectedAffector.Center:x() - selectedAffector.Width * 0.5,
                    selectedAffector.Center:y() - selectedAffector.Height * 0.5,
                    selectedAffector.Center:z() - selectedAffector.Depth * 0.5),
            mathfunction.vector3(selectedAffector.Center:x() + selectedAffector.Width * 0.5,
                    selectedAffector.Center:y() + selectedAffector.Height * 0.5,
                    selectedAffector.Center:z() + selectedAffector.Depth * 0.5));
  elseif selectedAffector:isType(apollocore.PositionConeAffector:RTTI()) then
    bindboxV = mathfunction.Aabbox3d(
            mathfunction.vector3(-0.1, 0, -0.1),
            mathfunction.vector3(0.1, 0.1, 0.1));
  elseif selectedAffector:isType(apollocore.PositionHemisphereAffector:RTTI()) then
    bindboxV = mathfunction.Aabbox3d(
            mathfunction.vector3(selectedAffector.Center:x() - selectedAffector.Radius,
                    selectedAffector.Center:y() - selectedAffector.Radius,
                    selectedAffector.Center:z() - selectedAffector.Radius),
            mathfunction.vector3(selectedAffector.Center:x() + selectedAffector.Radius,
                    selectedAffector.Center:y() + selectedAffector.Radius,
                    selectedAffector.Center:z() + selectedAffector.Radius));
  end
  local renderComp = emitter:GetComponent(apollocore.Node.CT_RENDER);
  renderComp:SetBindBox(bindboxV);
end

return SelectShapeAffectorCommand;