local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local CpuEmitterStartCommand = CommandBase:extend("CpuEmitterStartCommand");

function CpuEmitterStartCommand:new(uuid)
  CpuEmitterStartCommand.super.new(self);
  self._uuid = uuid;
end

function CpuEmitterStartCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local emi = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if emi then
      emi:Start();
    end
  end
  self:EndCmd();
end

function CpuEmitterStartCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local emi = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if emi then
      emi:Stop();
    end
  end
  self:EndCmd();
end

return CpuEmitterStartCommand;