local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local CpuEmitterResetCommand = CommandBase:extend("CpuEmitterResetCommand");

function CpuEmitterResetCommand:new(uuid)
  CpuEmitterResetCommand.super.new(self);
  self._uuid = uuid;
end

function CpuEmitterResetCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local emi = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if emi then
      emi:Reset();
    end
  end
  self:EndCmd();
end

function CpuEmitterResetCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local emi = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if emi then
      emi:Reset();
    end
  end
  self:EndCmd();
end

return CpuEmitterResetCommand;