local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AffectorRangePropertyChangeCommand = CommandBase:extend("AffectorRangePropertyChangeCommand");

function AffectorRangePropertyChangeCommand:new(nodeID, affectorType, typeIdx, propertyName, value, preValue)
  AffectorRangePropertyChangeCommand.super.new(self);
  self._nodeID = nodeID;
  self._affectorType = affectorType;
  self._typeIdx = typeIdx - 1;
  self._propertyName = propertyName;
  self._value = value;
  self._preValue = preValue;
end

function AffectorRangePropertyChangeCommand:DoIt()
  local affector = self:GetAffector(self._affectorType);
  if affector then
    affector.RandVolume[self._propertyName] = self._value;
  end
end

function AffectorRangePropertyChangeCommand:Undo()
  local affector = self:GetAffector(self._affectorType);
  if affector then
    affector.RandVolume[self._propertyName] = self._preValue
  end
end

function AffectorRangePropertyChangeCommand:GetAffector(typeName)
  local affector = nil;
  if self._nodeID then
    local emitter = self:GetContent(self._nodeID);
    if emitter then
      local j = 1;
      local types, affectors = emitter:GetAffectors();
      for i, aff in pairs(affectors) do
        if aff:GetTypeName() == typeName then
          if types[j] == self._typeIdx then
            return aff;
          end
          j = j + 1;
        end
      end
    end
  end
  return affector;
end

return AffectorRangePropertyChangeCommand;
