local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AffectorPropertyChangeCommand = CommandBase:extend("AffectorPropertyChangeCommand");

function AffectorPropertyChangeCommand:new(nodeID, affectorType, propertyName, value, callback)
  AffectorPropertyChangeCommand.super.new(self);
  self._nodeID = nodeID;
  self._affectorType = affectorType;
  self._propertyName = propertyName;
  self._value = value;
  self._callback = callback;
end

function AffectorPropertyChangeCommand:DoIt()
  self:BeginCmd();
  local affector = self:GetAffector(self._affectorType);
  if affector then
    self._preValue = self:GetProperty(affector, self._propertyName);--之前值
    self:SetProperty(affector, self._propertyName, self._value);
    if self._callback then
      local emitter = self:GetContent(self._nodeID);
      if emitter then
        self._callback(emitter);
      end
    end
  end
  self:EndCmd();
end

function AffectorPropertyChangeCommand:Undo()
  self:BeginCmd();
  local affector = self:GetAffector(self._affectorType);
  if affector then
    self:SetProperty(affector, self._propertyName, self._preValue);
    if self._callback then
      local emitter = self:GetContent(self._nodeID);
      if emitter then
        self._callback(emitter);
      end
    end
  end
  self:EndCmd();
end

function AffectorPropertyChangeCommand:GetAffector(typeName)
  local affector = nil;
  if self._nodeID then
    local emitter = self:GetContent(self._nodeID);
    if emitter then
      local types, affectors = emitter:GetAffectors();
      for i, aff in pairs(affectors) do
        if aff:GetTypeName() == typeName then
          return aff;
        end
      end
    end
  end
  return affector;
end

--使用table寻找更深层次的属性需要确保是引用类型
function AffectorPropertyChangeCommand:GetProperty(affector, propertyName)
  local value = nil;
  if type(propertyName) == "table" then
    value = affector;
    for i = 1, #propertyName do
      value = value[propertyName[i]];
    end
  else
    value = affector[propertyName];
  end
  return value;
end

function AffectorPropertyChangeCommand:SetProperty(affector, propertyName, value)
  if type(propertyName) == "table" then
    local temp = affector;
    for i = 1, #propertyName - 1 do
      temp = temp[propertyName[i]];
    end
    temp[propertyName[#propertyName]] = value;
  else
    affector[propertyName] = value;
  end
end

return AffectorPropertyChangeCommand;
