local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local IndependentFunctionCommand = CommandBase:extend("IndependentFunctionCommand");

function IndependentFunctionCommand:new(uuid,doParams,doFunc,undoParams,undoFunc)
  IndependentFunctionCommand.super.new(self);
  self._uuid = uuid;
  self._doFunc = doFunc;
  self._undoFunc = undoFunc;
  self._doParams = doParams;
  self._undoParams = undoParams;
end


function IndependentFunctionCommand:DoIt()
  if self._uuid then
    local object = self:GetContent(self._uuid);
    if object then
      self._doFunc(object,unpack(self._doParams));
    end
  end
end

function IndependentFunctionCommand:Undo()
  if self._uuid then
    local object = self:GetContent(self._uuid);
    if object and self._undoFunc then
      self._undoFunc(object,unpack(self._undoParams));
    end
  end
end

return IndependentFunctionCommand;