


local libvenuscore = require "libvenuscore"
local apollocore = require "apollocore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local DeleteDRComponentCommand = CommandBase:extend("DeleteDRComponentCommand");

function DeleteDRComponentCommand:new(nodeUUID)
  DeleteDRComponentCommand.super.new(self);
  self._nodeUUID = nodeUUID;
end


function DeleteDRComponentCommand:DoIt()
  self:BeginCmd();
  if self._nodeUUID then
    local object = self:GetContent(self._nodeUUID);
    if object then
      --保存下之前的UUID，undo的时候创建一个相同ID的component
      local component = object:GetComponent(apollocore.Node.CT_RENDER);
      self._comUUID = component:GetStaticID();
      object:DeleteComponent(apollocore.Node.CT_RENDER);
    end
  end
  self:EndCmd();
end

function DeleteDRComponentCommand:Undo()
  self:BeginCmd();
  local component = nil;
  if self._nodeUUID then
    local object = self:GetContent(self._nodeUUID);
    if object then
      component = object:CreateComponent(apollocore.Node.CT_RENDER);
      component:PushMetadata(apollocore.RenderObjectMeshFileMetadate(
          apollocore.VertexBufferEntity.MU_DYNAMIC, 
          "comm:documents/mesh/default.dynamicmesh"));
      component:CreateResource();
      component:SetStaticID(self._comUUID);
    end
  end
  self:EndCmd();
  return component;
end


return DeleteDRComponentCommand;
